///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _DBINIT_CPP
#define _DBINIT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/CGetPKs/CGetPKs.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"
#include "../../SharedSource/CRC32.H"

#include "Init.H"
#include "Routines.H"
#include "Console.H"
#include "DBInit.H"

#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/MainDlg.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GenerateDBCreationSQL(CSQL *lpCSQL, CSockSrvr *pSockSrvr, int iClient, char *sTargetFile)
{
	//WriteCon("GenerateDBCreationSQL\n");

	char sDB[1024];
	char sText[1024];
	char sSQL[10240];
	int iTempSz = 0;
	int iLen = 0;
	char sTableSQL[10240];
	char sPKSQL[10240];

	char sSmlTmp[64];
	char sType[255];
	char sCol[1024];
	char sPKName[1024];
	char sTable[1024];
	int iColLen = 0;
	int iColScale = 0;
	int iColPrec = 0;
	int iColStat = 0;
	int iIsPKCol = 0;

	CRecordSet rsTables;
	CRecordSet rsColumns;
	CRecordSet rsDatabases;

	FILE *hTarget = NULL;

	if(fopen_s(&hTarget, sTargetFile, "wb") != 0)
	{
		return false;
	}

	lpCSQL->bThrowErrors = true;
	rsDatabases.bThrowErrors = true;

	strcpy_s(sSQL, sizeof(sSQL), "SELECT [Name] FROM [SysDatabases]"
		" WHERE [Name] NOT LIKE 'SQLExch_%'"
		" AND [Name] NOT IN ('Master', 'Model', 'MSDB', 'TempDB')"
		" ORDER BY [Name]");
	lpCSQL->Execute(sSQL, &rsDatabases);	

	while(rsDatabases.Fetch())
	{
		rsDatabases.sColumnEx(1, sDB, sizeof(sDB), &iTempSz);

		sprintf_s(sSQL, sizeof(sSQL), "USE [%s]", sDB);
		if(!lpCSQL->ExecuteNonQuery(sSQL))
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Failed to change client database context. Performance will be affected.", EVENT_WARN);
		}

		//Create a record set containing all of the table names that contain SQLExch_Triggers
		sprintf_s(sSQL, sizeof(sSQL),
			"SELECT [Obj].[Name] AS [TableName], [PK].[Name] AS [PKName]"
			" FROM [%s].[%s].[SysObjects] AS [Obj], [%s].[%s].[SysObjects] AS [PK]"
			" WHERE [Obj].[xType] = 'U' AND (LEFT([Obj].[NAME], 8) <> 'SQLExch_'"
			"	AND LEFT([Obj].[NAME], 3) <> 'SYS'"
			"	AND [Obj].[ID] IN (SELECT [Parent_Obj]"
			" FROM [%s].[%s].[SysObjects] AS [A]"
			" WHERE [A].[xType] = 'TR'"
			"	AND LEFT([A].[NAME], 8) = 'SQLExch_'))"
			"	AND [PK].[Parent_Obj] = [Obj].[ID] AND [PK].[xType] = 'PK'"
			" ORDER BY [Obj].[Name]", 
			sDB, gsDefaultDBO, sDB, gsDefaultDBO, sDB, gsDefaultDBO);
		lpCSQL->Execute(sSQL, &rsTables);

		fwrite(&rsTables.RowCount, sizeof(rsTables.RowCount), 1, hTarget);

		//Loop through all of the tables that have triggers.
		while(rsTables.Fetch())
		{
			//Get the table name, save it in sTable[]
			rsTables.sColumnEx(1, sTable, sizeof(sTable), &iTempSz);
			//Get the PK name, save it in sPKName[]
			rsTables.sColumnEx(2, sPKName, sizeof(sPKName), &iTempSz);

			sprintf_s(sText, sizeof(sText), "Generating SQL for %s.%s", sDB, sTable);
			WriteLogEx(pSockSrvr->icClientID[iClient], sText, EVENT_NONE);

			sprintf_s(sSQL, sizeof(sSQL),
				"SELECT"
				" [Columns].[Name],"
				" [Types].[Name],"
				" (CASE WHEN [Types].[Name] IN ('nchar', 'nvarchar') THEN [Columns].[Prec] ELSE [Columns].[Length] END) AS [Length],"
				" [Columns].[Prec],"
				" [Columns].[xScale],"
				" (CASE"
				"	WHEN [Types].[Name] IN ('Binary', 'Char', 'nChar', 'nVarChar', 'VarBinary', 'VarChar')"
				"		THEN 1" //Requires column Length to be specified.
				"	WHEN [Types].[Name] IN ('Decimal')"
				"		THEN 2" //Requires column Precision and Scale to be specified
				"	ELSE 0"		//Column does not require Length, Precision or Scale to be specified
				" END) AS [TypeStatus],"
				" IsNull((SELECT 1 FROM [%s].[%s].[SysObjects] AS [Objects],"
				" [%s].[%s].[SysIndexes] AS [Indexes],"
				" [%s].[%s].[SysIndexKeys] AS [IndexKeys]"
				" WHERE [Objects].[xtype] = 'PK' AND [Objects].[Name] = [Indexes].[Name]"
				" AND [Indexes].[IndId] = [IndexKeys].[IndId] AND [Indexes].[ID] = [IndexKeys].[ID]"
				" AND [IndexKeys].[ColId] = [Columns].[ColId]"
				" AND [Objects].[Parent_Obj] = [Columns].[ID]"
				" AND [Objects].[Parent_Obj] = [Columns].[ID]), 0) AS [IsPK]"
				" FROM [%s].[%s].[SysColumns] AS [Columns]"
				" INNER JOIN [%s].[%s].[SysTypes] AS [Types] ON [Columns].[xType] = [Types].[xUserType]"
				" WHERE [Columns].[ID] = Object_ID('[%s].[%s].[%s]')"
				" ORDER BY [Columns].[ColOrder]", 
				sDB, gsDefaultDBO, sDB, gsDefaultDBO,
				sDB, gsDefaultDBO, sDB, gsDefaultDBO,
				sDB, gsDefaultDBO, sDB, gsDefaultDBO, sTable);
			lpCSQL->Execute(sSQL, &rsColumns);
				
			sprintf_s(sTableSQL, sizeof(sTableSQL),
				"CREATE TABLE [{SQLExch_TAG_DB}].[DBO].[%s] (\r\n", sTable);

			sprintf_s(sPKSQL, sizeof(sPKSQL), "\tCONSTRAINT [");
			strcat_s(sPKSQL, sizeof(sPKSQL), sPKName);
			strcat_s(sPKSQL, sizeof(sPKSQL), "] PRIMARY KEY CLUSTERED\r\n");
			strcat_s(sPKSQL, sizeof(sPKSQL), "\t(\r\n");

			while(rsColumns.Fetch())
			{
				//Get the column name, save it in sCol[]
				rsColumns.sColumnEx(1, sCol, sizeof(sCol), &iTempSz);

				//Get the type name, save it in sType[]
				rsColumns.sColumnEx(2, sType, sizeof(sType), &iTempSz);

				//Get the column length.
				iColLen = rsColumns.lColumn(3);

				//Get the column precision.
				iColPrec = rsColumns.lColumn(4);

				//Get the column precision.
				iColScale = rsColumns.lColumn(5);

				//Get the column type status.
				iColStat = rsColumns.lColumn(6);

				//Get the Is PK column flag.
				iIsPKCol = rsColumns.lColumn(7);

				strcat_s(sTableSQL, sizeof(sTableSQL), "\t[");
				strcat_s(sTableSQL, sizeof(sTableSQL), sCol);
				strcat_s(sTableSQL, sizeof(sTableSQL), "] ");

				strcat_s(sTableSQL, sizeof(sTableSQL), sType);

				if(iColStat == 1)
				{
					if(iColLen <= 0)
					{
						strcat_s(sTableSQL, sizeof(sTableSQL), "(MAX)");
					}
					else{
						sprintf_s(sSmlTmp, sizeof(sSmlTmp), " (%d)", iColLen);
						strcat_s(sTableSQL, sizeof(sTableSQL), sSmlTmp);
					}
				}
				else if(iColStat == 2)
				{
					sprintf_s(sSmlTmp, sizeof(sSmlTmp), " (%d, %d)", iColPrec, iColScale);
					strcat_s(sTableSQL, sizeof(sTableSQL), sSmlTmp);
				}

				if(iIsPKCol > 0)
				{
					strcat_s(sPKSQL, sizeof(sPKSQL), "\t\t[");
					strcat_s(sPKSQL, sizeof(sPKSQL), sCol);
					strcat_s(sPKSQL, sizeof(sPKSQL), "],\r\n");
					strcat_s(sTableSQL, sizeof(sTableSQL), " NOT NULL,\r\n");
				}
				else{
					strcat_s(sTableSQL, sizeof(sTableSQL), " NULL,\r\n");
				}
			}

			sPKSQL[strlen(sPKSQL) - 3] = '\0';
			sTableSQL[strlen(sTableSQL) - 3] = '\0';

			strcat_s(sPKSQL, sizeof(sPKSQL), "\r\n\t) ON [PRIMARY]");

			strcat_s(sTableSQL, sizeof(sTableSQL), "\r\n");
			strcat_s(sTableSQL, sizeof(sTableSQL), sPKSQL);
			strcat_s(sTableSQL, sizeof(sTableSQL), "\r\n");

			strcat_s(sTableSQL, sizeof(sTableSQL), ") ON [PRIMARY]\r\n");

			rsColumns.Close();

			//Write Database Name.
			iLen = strlen(sDB);
			fwrite(&iLen, sizeof(iLen), 1, hTarget);
			fwrite(sDB, sizeof(char), iLen, hTarget);

			//Write Table Name.
			iLen = strlen(sTable);
			fwrite(&iLen, sizeof(iLen), 1, hTarget);
			fwrite(sTable, sizeof(char), iLen, hTarget);

			//Write PK Name.
			iLen = strlen(sPKName);
			fwrite(&iLen, sizeof(iLen), 1, hTarget);
			fwrite(sPKName, sizeof(char), iLen, hTarget);

			//Write SQL.
			iLen = strlen(sTableSQL);
			fwrite(&iLen, sizeof(iLen), 1, hTarget);
			fwrite(sTableSQL, sizeof(char), iLen, hTarget);
		}	

		rsTables.Close();
	}	

	rsDatabases.Close();
	
	fclose(hTarget);

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
